/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.tool.collection;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.codefilarete.tool.collection.ArrayIterator;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.Test;

class ArrayIteratorTest {
    ArrayIteratorTest() {
    }

    @Test
    public void testNext() {
        ArrayIterator testInstance = new ArrayIterator((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat((List)Iterables.copy((Iterator)testInstance)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"a", "b", "c"}));
    }

    @Test
    public void testNext_throwsNoSuchElementException() {
        ArrayIterator testInstance = new ArrayIterator((Object[])new String[]{"a"});
        Assertions.assertThat((boolean)testInstance.hasNext()).isTrue();
        testInstance.next();
        Assertions.assertThat((boolean)testInstance.hasNext()).isFalse();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((ArrayIterator)testInstance).next());
        testInstance = new ArrayIterator((Object[])new String[]{"a"});
        testInstance.next();
        Assertions.assertThatExceptionOfType(NoSuchElementException.class).isThrownBy(() -> ((ArrayIterator)testInstance).next());
    }
}

